TCJ #44

                            The Z-System Corner

                                  Jay Sage


   For this issue (and the next) I am going to indulge myself and write
about about something that I enjoy, even though, strictly speaking, it has
nothing to do with Z-System.  This subject is MEX-Plus, the most advanced
telecommunications package available for CP/M computers.  I suppose I could
argue that there is a philosophical or spiritual connection, since MEX-Plus
allows the user do for telecommunications many of the same things that Z
System allows one to do with the operating system, namely automate.  In
particular, I will be describing MEX-Plus's scripting capabilities, which
are similar in some ways to alias and ARUNZ scripts in Z-System.

   I had been hoping that a regular MEX column would develop here in TCJ,
but that hasn't happened.  Two of the people who might have gotten it going,
Bruce Morgen and Rick Charnes, are now employed in the MS-DOS industry, and,
after programming all day professionally, they don't seem to have as much
energy left for hobby computing as they used to.  Recently, David
Goodenough, author of the QTERM telecommunications package, came over to my
house and got QTERM running on my SB180 with its Wyse 50 terminal.  I am
enormously impressed with what David has accomplished with this program; it
is rapidly developing many of the capabilities of MEX-Plus.  I can envision
much discussion in the future of both MEX-Plus and QTERM scripts.  You can
also expect an article or two about QTERM.

   For this column I will give an overview of MEX's command structure, and
next time I will describe in detail my suite of scripts for using PC-Pursuit
as an example of what can be done using those commands.  (I originally
planned to cover both in one article, but after finishing the description of
the commands, I was already at my limit.)  Along the way I will try to point
out some of the bugs and idiosyncrasies that users have discovered in MEX
commands and suggest means to get around them.  I hope that my examples will
help give others ideas about how to make better use of MEX-Plus.  Although
regrettably I have had very few takers in the past, I again extend an
invitation to readers to send me suggestions and examples for scripts.


                         Overview of MEX Commands


   The original CP/M telecommunication program MODEM7 and its derivatives,
such as IMP, operate in two modes: terminal mode and command mode.  Terminal
mode is used for talking to the remote system, while command mode is used to
control the local system.  These programs have a relatively small set of
commands falling principally into two classes: those required for file
transfers and those related to the setup of the program.

   In MEX-Plus the arsenal of commands is extended enormously, and anything
that could be done from terminal mode can be done from command mode as well. 
(You would not want to run an interactive session this way, but it could be
done.)  There are so many commands that, though I will mention almost all of
them, I will not be able to explain them all in detail.  Rather, I hope to
give you a general picture of the kinds of tools one has to work with in
MEX-Plus.  I will take up the commands in groups.


Setup Commands
--------------

   Most of MEX's configuration is controlled by three commands: STAT, SET,
and TSET.  The STAT command works with more than 50 different options!  All
of them can display information about how the system is configured, and all
but a few also allow the configuration to be changed.  The MEX STAT
parameters fall into four classes: switches, characters, values, and
miscellaneous.

   Switches have values of ON or OFF.  One example is FILTER, which controls
whether MEX will filter from the incoming modem stream any control
characters other than tab, backspace, carriage return, and linefeed.  If one
wants to perform full screen operations, this filter must be off. 
Otherwise, the escape characters that initiate a screen control sequence
will be swallowed by MEX.

   Character STAT parameters take a single ASCII character as their value. 
An example is SEP, the multiple command separator (like Z-System, MEX-Plus
allows multiple commands on a line).  Value parameters take on numerical
values.  For example, PAGE sets the number of lines in a page on the screen,
and CLOCK is set to the clock speed of your microprocessor chip so that
timing delays will come out right.  The miscellaneous STAT parameters mostly
control the display of groups of information.  "STAT ?" lists all the STAT
parameters; "STAT VAL" shows the value parameters.

   The SET command controls the modem setup.  It is used for setting the
baud rate, word length, number of stop bits, and parity mode.  The TSET
command was one I never used until working on this article.  It controls
special features related to the terminal (what is does depends on the
terminal you are using).  With my Wyse 50, a TSET parameter can force all
characters to be displayed in upper case characters or in highlighted video
(that should give you some idea of why I have never used this command).


Operating System Commands
-------------------------

   Another group of commands deals with the interface to the operating
system.

   Naturally, there has to be a way to get out of MEX and back to the
operating system prompt.  Have you ever been trapped inside a program, not
knowing how to exit?  Well, MEX author Ron Fowler must have had such a
harrowing experience, because he has six (count 'em!) commands for getting
out: BYE, EXIT, QUIT, CPM, DOS, and SYSTEM.  SYSTEM must come from BASIC,
which is the only CP/M program I ever became trapped inside.  MEX-Plus is
available in an MS-DOS version as well, and that is where the exit command
DOS comes from.  As a CP/M diehard, I take great pleasure, as you can
imagine, in exiting from my DOS version using the command CPM (it doesn't
help -- I'm still in MS-DOS after I exit).

   There are commands for doing operating system chores: DIR, REN, ERA (or,
following MS-DOS, DEL), TYPE, and LOG (change drive/user).  Some of these
commands not only perform their functions; they also return information for
use in a script file.  DIR, for example, sets a special variable to the
number of matching files found, and thus can be used to determine whether a
particular file exists or not.

   There are the commands KEY for associating strings with any ASCII key on
the keyboard and PHONE for entering phone numbers into a dialing library. 
The key definitions and phone number library can be stored in disk files
with the respective extensions KEY and PHN.  The commands SAVE and LOAD
write the data to and read the data from the files.

   MEX-Plus has a facility, via the INSTALL command, to load optional extra
code modules.  One such module (the REMOTE module) allows MEX-Plus to be
operated as a remote access system.  I have used this with both direct wire
and modem connections between machines.  The former is handy when two
machines are connected by a cable, as it relieves one of the need to run
back and forth between the two keyboards to issue file transfer commands.  I
sometimes leave my system at work in remote mode so that I can call it from
home to pick up a file that I forgot to take with me.  Other optional
modules support emulation of various terminals, including the VT100.

   The TERM and TERMA commands open a file to record the incoming character
stream from the modem.  TERM creates a new file, while TERMA appends the new
text to an existing file.  The terminal mode commands T, L, and E described
below can also take an optional 'A' suffix and capture file name.  In those
cases, once the capture file has been opened, MEX is put into terminal mode. 
The TERM and TERMA commands leave MEX in command mode for further script
processing.  The VIEW command allows the contents of the capture file to be
reviewed while online, thereby affording some scroll-back capability (that
is, a way to see text that has already scrolled off the screen).  WRT closes
the capture file (saves it) when you are done; DEL discards it.

   The ALT command specifies an alternate drive/user area (in addition to
the currently logged one) where MEX can search automatically for files
(e.g., scripts, phone directory, etc.).  The SEARCH command tells MEX how to
go about searching for files, such as whether to search the alternate area
before or after the logged area.

   As you can probably guess already, it is not easy to remember all these
commands and the syntax they require.  That is where the HELP command comes
in handy.  It accesses an extensive HLP file (over 70K).  There is also the
wonderful CLONE command, which creates a new version of MEX (i.e., a new COM
file) with the current configuration embedded -- after the STAT, SET, TSET,
and other commands have been used to change parameters to one's liking.


Telephone Interface Commands
----------------------------

   MEX-Plus has two phone-dialing commands, CALL and DIAL.  Both accept
lists of either literal telephone numbers or names from the phone library. 
Numbers and names may be mixed.  Numbers in the library may have associated
baud rates, which will be selected automatically when that number is dialed. 
An optional parameter specifies the number of times to try connecting to the
numbers before giving up, and the commands return a value to indicate which
number, if any, was reached.  Here is an example:

                CALL LADERA 617-965-7259 #3

This will alternately called the Ladera Z-Node (whose number is in the
library) and my Z-Node up to three times before giving up.  The commands
differ in that CALL puts one in terminal mode after a successful connection,
while DIAL leaves one in command mode for further script processing.

   There is also a way to get out of a connection.  DSC will tell the modem
to drop the connection.  It can be configured (using a STAT command, of
course) to use either the DTR (data terminal ready) hardware control line or
the Hayes AT hangup command.


Terminal Commands
-----------------

   There are three commands for entering terminal mode.  The command T
(terminal) sets up a full-duplex terminal mode.  Characters typed at the
keyboard are sent to the modem; characters received from the modem are sent
to the screen.  If you are to see what you are typing, the remote system
must echo back the characters it receives from you.  Most microcomputer BBS
systems do that.

   The L (local echo) command sets up a half-duplex terminal mode.  The
difference is that the characters that you type are not only sent to the
modem for transmission to the remote system; they are also echoed locally. 
This mode would be used with systems like GEnie that do not normally echo
the characters they receive from you.

   Finally, the E (echo) command sets you up as if you were a remote host. 
Every character you receive is then echoed back to the modem.  If two people
running MEX call each other (or two machines are hooked up by cable as I
mentioned earlier), either both should be in L mode, or one should be in T
mode and the other in E mode.  I prefer the latter, since seeing the
characters on the screen of the machine in T mode assures that the
connection is working.  I leave it as an exercise to the reader to figure
out what will happen if both machines are in E mode.  (Hint: feel free to
experiment; you can get out of the infinite loop by exiting from terminal
mode; you don't have to reboot.)


File Transfer Commands
----------------------

   Files are sent to the other computer using the S command, and received
from the other computer using the R command.  MEX-Plus supports three file
transfer protocols: KERMIT, XMODEM, and YMODEM.  The default protocol is set
with the PROTO command.  The protocol can also be specified explicitly using
a prefix (K, M, or Y) to the S or R command.

   The commands will also accept any of several suffixes as well.  The
suffix B indicates a batch-mode transfer.  The K suffix with the S command
indicates that the file should be sent in blocks of 1K bytes instead of the
standard 128 bytes.  If you append T, L, or E, you will return to the
corresponding terminal mode after the transfer is completed.  The D and X
suffixes will tell MEX to disconnect from the remote system after the
transfer is finished; with D you will return to MEX, while with X you will
exit MEX as well.  Here is an example.

                YSBKX FILE1 FILE2 FILE3

This will send the three files using YMODEM batch with 1K blocks, hang up
the phone, and exit from MEX.

   Transactions with a host in the KERMIT server mode are supported with a
number of special commands (KGET, KPUT, KBYE, KLOG, KFIN).


Video Commands
--------------

   These are the commands that Rick Charnes loves so!  There are commands
for cursor addressing (@), beginning and ending the use of up to four video
attributes (START and END), displaying special line-drawing graphics
characters (DRAW), and creating lines and boxes (HLINE, VLINE, BOX).  The
screen can be cleared (CLS).  It can also be turned on and off (SCREEN) so
you can control what output is seen and what is not.


Variables
---------

   It is hard to do very sophisticated processing without variables.  MEX
Plus offers variables of two types: numerical and string.  The former are
16-bit integers (i.e., numbers from 0 to 65535); the latter are strings of
up to 32 characters.

   There are 26 numerical user variables designated by a percent sign
followed by a letter (case does not matter, e.g., %a or %S).  There are six
string variables designated by the letters A through F.  I've never run out
of numerical variables, but I sure wish there were more string variables.

   There are also two special numerical variables called VALUE and STACK. 
The former is used to hold the value returned from a number of MEX commands
(DIR and DIAL/CALL were mentioned earlier).  STACK is a more long-lived
variable that can be exchanged in various ways with VALUE (the commands
PUSH, POP, and XCHG).  I think these are left over from earlier versions of
MEX that did not offer the 26 user variables.  There is little reason to use
STACK any more.  There are three special operations (ADD, SUB, and XOR) that
can be performed on the VALUE variable.  I've never found any use for these,
either.

   MEX can evaluate arithmetic expressions consisting of combinations of
literal numbers, numerical variables, and arithmetic operators (+-*/).  Here
is an example that returns the least significant byte of the two-byte
variable %V:

                %V - 256 * ( %V / 256 )

Numbers can be entered in hexadecimal format by prefixing the number with a
dollar sign ($100 is 256).

   The value of an expression is assigned to a variable by the equal
operator (=) as in %B=%A+3.  NOTE: in most places in MEX-Plus, extra spaces
may be included in command expressions.  However, there are unfortunately a
number of bugs in MEX-Plus, and some rear their heads in this area. 
Therefore, I recommend that extra spaces be omitted in working scripts (as
opposed to fully commented reference versions, where extra spaces might be
included to improve readability).

   Literal string expressions are composed by surrounding text with double
quote characters (").  The MEX manual says that values are assigned to
string variables using the STORE command as in:

             STORE "this is a test" TO A.

Experiment shows that the following simpler, undocumented syntax also works:
A="test".  Here I know from bitter experience that there should be no extra
spaces around the equal sign.  It often works, but not always.  Most
commands that accept quoted literal strings will also accept string
variables (e.g., B=A or COMP A "yes").

   Command line parameters are also available to scripts; they are passed in
the form of variables represented by the numbers 1 through 9 surrounded by
curly braces.  These variables can always act as strings.  If they express a
number, they can also be used as numerical expressions.  Thus, we might have
A="{1}" or %A={1}.  The latter expression will produce an error if the first
command line token does not represent a number.

   If the script invocation command line does not have a token referenced by
an expression of the form {1}, {2}, etc., the script will bomb with an error
message.  The expression {n:default) allows a default value to be used for
parameter 'n' if none is given on the command line.  This default value can
be null, as in {1:}.

   String variables can, like the command line tokens, be represented in
expressions by curly braces around the letter (e.g., {B}).  In such a case,
the value of the expression is the string of characters alone, and double
quote characters must surround the expression in most situations.  There are
exceptions.  The SAY and SENDOUT commands (described in the next section)
can be used directly with a variable, as in SAY A.  The following two
commands are equivalent:

                SAY "Variable A has the value: ",A,"/n"
                SAY "Variable A has the value: {A}/n"

   The curly-brace expressions can be used to concatenate text, as in

                A="{B} and {C}"

Expressions of this type are not documented and work only in script files;
they will not work if entered directly at the MEX command prompt.  Similar
expressions can also be used to finesse variables into commands that
normally do not take them.  Here are some examples:

                set baud {b}       (where, say, B="1200")
                set baud {c}00     (where, say, C="24")
                goto {1}           (where, say, token 1 is LOOP)
                {a}                (where, say, A="set baud 1200")

   I have not figured out how to split a string variable into parts (such as
words).  I also had never been able to figure out a way to convert a
numerical variable into a string.  I still can't do it directly (things like
B={%B} do not work), but the script in Fig. 1 does it indirectly (inventions
like this are part of the fun of writing this column).  You may not be able
to fully understand that script until you have read through the rest of the
command descriptions.

-----------------------------------------------------------------------------

B=""                    initialize to null string
%y=%b                   set up scratch variable %y

LABEL LOOP              loop
%x=%y-10*(%y/10)        get the lowest digit ( %y MOD 10 )
if %x=0 B="0{B}"        preconcatenate the appropriate digit
if %x=1 B="1{B}"
if %x=2 B="2{B}"
if %x=3 B="3{B}"
if %x=4 B="4{B}"
if %x=5 B="5{B}"
if %x=6 B="6{B}"
if %x=7 B="7{B}"
if %x=8 B="8{B}"
if %x=9 B="9{B}"
%y=%y/10                divide number by 10
if %y>0 GOTO LOOP       continue until number is reduced to 0

Figure 1.  Commented listing of a script that will convert the numerical
variable %B into string form in string variable B, from which it can be used
in various commands, such as: SET BAUD {B}.  This code could be made into a
subroutine by adding the command PROC NUM2STR at the beginning and ENDP at
the end.  If you try this script, do not enter the comments, of course.

-----------------------------------------------------------------------------


Input/Output Commands
---------------------

   Programs generally are not terribly useful if there is no way to get data
in or out.  Here is what MEX-Plus offers.

   The SAY command allows one to send characters to the screen.  It accepts
arguments of literal strings, string variables, and numerical expressions,
as in

                SAY "The sum is",%A+%B,"/n"

There are special character codes, such as "/n" (newline) or "/r" (return). 
Combined with the video commands mentioned earlier, the SAY command can
produce some pretty fancy displays.

   There is also the undocumented PRINT command that does almost exactly
what SAY does, except that it does not need quotation marks around the
literal text and does not interpret any special expressions.  To PRINT,
everything is a pure string.  There are, thus, a couple of things PRINT can
do that SAY cannot.  Here are some examples:

                PRINT Please enter "Hello" at the prompt.
		PRINT Use the expression {1} for a token.

In the first case, PRINT allows one to send a double quote character to the
screen.  In the second case, a string that would be a variable expression
can be displayed.

   The SENDOUT command is used to send literal text or the contents of
string variables to the modem.  The PREFIX and SUFFIX commands can be used
to define strings that are automatically sent before and after the
designated text to save one the trouble of having to include certain
characters (such as, perhaps, a carriage return and linefeed) explicitly
with each string.  Longer, fixed strings can be sent using the TRANSMIT
command, which sends the contents of a file just as if you were typing it in
terminal mode.  A pair of delay constants controls the speed with which this
"automatic typist" performs.

   The INPUT command allows interactive entry of the value for a numerical
variable; ACCEPT does the same thing for a string variable.  The TIME and
DATE commands allow one to access a real-time clock.  Besides displaying the
information on the screen, the commands are supposed to put the
corresponding data into the VALUE variable.  There is a bug here, and the
time value is used by both commands.  There appears to be no way to
determine the date from within a script.  The PEEK and POKE commands allow
one to look at and modify memory for the ultimate in hacking from a script! 
(That probably means that there would be a way to find the date if one
really needed it badly.  It also means that the complete Z-System
environment can be accessed.)


Flow Control Commands
---------------------

   Like Z-System, MEX-Plus has flow control commands to allow a script to
perform tests and to act differently depending on the results.  There is the
standard set of flow commands IF, ELSE, and ENDIF.  They support 8 levels of
nesting (just like Z-System).  Here is an example:

                IF %B=1200
                  B="1200"
                ELSE
                  B="2400"
                ENDIF

   Additionally, there is a single-line IF command.  It is distinguished
from the multiple-line IF by a command (a 'then' clause) that is part of the
IF statement.  Here is an example:

                IF %B=2400 B="2400";SAY "2400 bps";GOTO CONTINUE

With the single-line IF, when the test fails, the entire line is ignored. 
Please note that had there been a semicolon after the "IF %B=2400", then
this would have been a multiple-line IF (albeit with several of its 'lines'
on one line).

   The single-line IF command comes in especially handy, because it is
generally awkward to perform a GOTO jump out of an IF/ELSE/ENDIF block. 
Although the manual warns against it, there is (I'm pretty sure) no harm per
se in doing it.  It is just that you have to make sure that the ENDIF is not
skipped lest you get nested deeper and deeper.  As with Z-System, you have
to make sure the IFs get terminated; unfortunately, this is not so easy,
because, unlike Z-System, MEX-Plus has no XIF or ZIF command.  Here is a
very convoluted example of a way in which it could be done:

                if %b
                  say "TRUE/n"
                  goto cont
                endif
                .
                say "FALSE/n"
                goto done
                .
                label cont
                endif
                .
                label done
                say "Now we are done/n"

   There is also a SKIPIF command.  If its test is true, then the next
command is skipped.  Note well that while the IF command may skip an entire
line of commands, SKIPIF skips only one command, no matter how many commands
may appear on the same line.


Numerical Tests
---------------

   Flow control would not be very useful without ways to test things.  First
we will consider tests on numbers.

   Test results are expressed numerically, with 0 representing false and
non-zero (usually 1) representing true.  You can see this for yourself by
entering the command "SAY 1<2" or "SAY 1>2".  The following logical
operators can be used for comparisons: equals (=), not equals (<>), less
than (<), less than or equal to (<= or =<), greater than (>), or greater
than or equal to (>= or =>).  Note that the MEX manual has a misprint in one
place and gives the not-equal-to operator as '!'.  That is incorrect and
will not work.

   Although comparison tests return a numerical value, those values for some
reason cannot be used in arithmetic expressions.  In other words, you can't
have (%A>%B)*(%A<%C).  As far as I can tell, this means that you cannot
perform compound tests, such as "IF %A>%B AND %A<%C".  Performing such
compound tests is made more difficult by the fact that the 'then' clause of
a single-line IF cannot be another IF.  If you won't be using GOTO, nested
multi-line IF commands will do the trick.  Otherwise, you might have to
resort to some explicit arithmetic as in the following:

                %z=1
                if %a<=%b then %z=0
                if %a>=%c then %z=0  
                if %z then ....

We started out assuming TRUE (%z=1).  Then if either condition was false, we
set %z to false.

   Before we leave this topic (I know we've been here a long time), I have
to mention that MEX has a bug that causes it to issue fallacious but very
annoying error reports when comparison operations are performed with
numerical variables having particular values.  I have carried out a number
of experiments to try to determine the exact circumstances under which this
problem occurs, but so far I cannot fathom a pattern.  The trouble often
appears, however, with comparisons to standard data rate values, such as
300.  To get around the problem, I sometimes divide the variable by 100,
compare it to 3, 12, or 24, and then multiply it by 100 to restore its
original value.  What a pain!


String Tests
------------

   Strings are compared using the COMP command.  It accepts two strings,
each of which can be either a literal string or a string variable.  The
result of the comparison is returned in the VALUE variable, which can then
be tested for a value of 0 or 1.  The STAT CASE setting determines whether
the comparison will be case sensitive or not.  There is a bug with the COMP
command; it will not give the answer 1 (true) when both strings are null
(""), though it will work if only one string is null.  If you want to see if
a command line token was given, you can use the following tests:

                COMP "{1:} " " "
                COMP "{1:}X" "X"

An extra character (space or 'X') is concatenated to the string represented
by {1:}.  You might also use

                COMP "{1:null}" "null"

Here, the first parameter cannot be null.  If token 1 is not given, the
default value "null" will be used instead.  Of course, if the user enters
"null", the same result will be obtained.  The two earlier examples are,
thus, more robust.

   There is one oddball command that I don't know where to put: SLEEP.  It
is sort of a flow control command, so I'll stick it here.  It just tells the
system to go to sleep (pause) for a designated time interval.


Program Control Commands
------------------------

   MEX-Plus supports several script program structures.  The main unit of a
script program is a script file, which has a file extension of MEX.  It can
be invoked as a main program by the READ command.  It can also be invoked as
a subprogram by the DO command, which allows scripts to be nested.  I do not
know how deep this nesting can be, but I just tested it to five levels.  The
STOP command is used to exit from a READ or DO command.  In the former case,
control returns to the MEX program (possibly in terminal mode); in the
latter, control returns to the script that called the current script.  A
script also terminates automatically at the end-of-file.  The STOP command
unfortunately displays an annoying message about the script being aborted. 
To exit gracefully, it is better to put a label at the end (e.g., LABEL END)
and to exit using GOTO END.

   A READ command may be given inside a script.  In this case, control is
transferred to the new script, which overwrites the old script in memory. 
With the DO command, the new script lines are read into memory along with
the currently running script.

   I always enjoy writing these columns because I end up asking some new
questions and learning some new answers.  Just now, to see how MEX works, I
was examining the memory image after a MEX script file ran.  First, I
learned that the script text is stored backwards in memory starting from
near the top.  I verified that after each DO is finished, the memory is
reclaimed and is available for use by another subroutine script.  I also
discovered that the entire script file, including all comments, is read into
memory.

   We can draw some important conclusions from these observations about how
complex scripts should be implemented.  First, there are several advantages
to using versions of script files from which comments have been stripped. 
The files will, of course, load faster, and there will also be more room in
memory for such things as file transfer buffers.  Many MEX users have run
into problems of insufficient memory while running complex scripts.  Second,
it is a good idea to chain from one script to another rather than building
everything into a single script.  In my PC-Pursuit script, I chain to a very
small script just after the remote system has been reached and the script is
about to put me into terminal mode.

   Structure is permitted within an individual script file as well in the
form of internal subroutines.  Subroutines begin with a PROC (procedure)
command and end with an ENDP (end-procedure) command.  They are invoked by
the GOSUB command.  Again, I do not know how deeply they may be nested, but
I just tested them to 9 levels.

   Script files may also contain unstructured program groupings (that
anathema to modern structured programming).  The LABEL command allows any
point in the script to be given a name, and the GOTO command allows a branch
to that point.  The manual indicates that the name may have up to 16
alphabetic characters and warns that the line with the LABEL command may not
have any other commands on the line.  I know that I have run afoul of that
restriction in the past, but, oddly enough, in my testing now I was totally
unable to generate a problem.  I tried everything I could think of: an
immediate semicolon, a semicolon after a space or a tab, tabs after the
semicolon.  They all worked just fine (how could MEX tell that this was just
a test?).

   The manual is clearly wrong when it says that only alphabetic characters
can be used.  I assumed that it really meant alphanumeric, but in my
experiments I learned that absolutely any characters can be used, including
spaces!  Here are the rules that emerged from my testing.  First, all spaces
and tabs after the LABEL command are ignored.  That point marks the
beginning of the name.  Next one starts from the end of the line or the
command separator character and strips all tabs and spaces backward.  That
point marks the end of the name.  What is between those marks is taken as
the label.  For example, one can have a label of "ENTRY 1" (with the
embedded space and with or without the quote characters, in fact).  Mind
you, I am not by any means suggesting that you use such labels.  As I
mentioned before, I have not always found MEX to behave exactly the way it
did in these experiments.  If anyone can figure this out more precisely, I
would really like to hear about it.

   The other thing I learned from these experiments is that MEX always scans
for a label from the beginning of the script.  This means that if you use
the same label a second time, the second occurrence will never be found.


                            One Script Example

   I just don't feel right about presenting all this information about MEX
Plus commands without showing at least one real-life example.  Figure 2
shows the final script in my PC-Pursuit script suite.  Once I have
successfully connected to the outdial city and reached the remote system
there, I chain to this script.  Let's look at it line by line.

   The first line begins with a period, so it is a comment.  I always
include a title line and often add some description of the function of the
script and the parameters it takes.

   The real work of the script begins at line 3.  In many parts of the
script, I do not want the output from commands to show on the screen.  Now I
do, so I issue the "SCREEN ON" command.  I'd also like to start with a clean
screen, so I issue CLS, too.

   In line 5, the script tells the user the name of the system that has been
reached (that was previously stored in string variable F) and at what baud
rate (previously stored in string variable B).  Then the script drops one
into terminal mode, where one can work interactively as long as one likes.

   When terminal mode is exited (by pressing <ESC> E), the script resumes at
the label LOOP.  Line 9 prompts the user to enter a command.  If the user
enters "M", then the main menu script is run, allowing one to call another
system in another or the same city.  Line 10 accepts the answer from the
user and places it into string variable A.

   In line 11, the user's answer is compared to the string "M".  If it was
"M", then the variable VALUE will have the value 1 (true), and line 12 will
cause the script to chain to the script file PCPMENU.MEX.  If the user
entered anything other than "M", then execution will continue at line 13,
where the user's command is executed.  When that command has completed,
control will return to line 14, which branches back to label LOOP and a
prompt for another command.

   The user's command can be just about anything.  For example, if it is
"T", then MEX will enter terminal mode for more interactive work.  The one
restriction I have found, is that only a single command can be entered.  A
multiple command line, with commands separated by semicolons (or whatever
the designated SEP character is), does not work for reasons I do not yet
understand.  Maybe I will have figured it out (or one of you will have) by
next time, when I will cover the real guts of the PC-Pursuit script.

-----------------------------------------------------------------------------

01  .. PCPCONN SCRIPT -- Connected to Destination System
02  
03  screen on
04  cls
05  say "Connected to ",F," at ",B,"00 bps/n/n"
06  t
07  
08  LABEL LOOP
09  say "/nEnter single MEX command (or M for menu): "
10  accept A
11  comp A "M"
12  if value=1 READ PCPMENU
13  {A}
14  GOTO LOOP

Figure 2.  This is the final script in my PC-Pursuit suite.  Just after
connecting to a remote system, I chain to this script to free up as much
memory as possible for other uses, such as capture buffers and/or file
transfer buffers.  Line numbers have been added for reference purposes in
the text.

              